/** @file   menusavegame.cpp
 * @brief   Implementation of MenuSaveGame - class.
 * @version $Revision: 1.3 $
 * @author  Tomi Lamminsaari
 */

#include "menusavegame.h"
#include "GfxManager.h"
#include "soundsamples.h"
#include "eng2d.h"
using namespace eng2d;
using std::string;

namespace WeWantWar {


const int MenuSaveGame::BACK_TO_LEVEL_MENU;



MenuSaveGame::MenuSaveGame() :
  MenuPage()
{
  for (int i=0; i < 6; i++) {
    m_slots.push_back( SaveSlot(i) );
  }
}


MenuSaveGame::~MenuSaveGame()
{
}


int MenuSaveGame::update()
{
  int ret = MenuPage::NO_PAGE_CHANGE;
  if ( key[MenuPage::s_lastKey] ) {
    return ret;
  }

  MenuPage::s_lastKey = KEY_O;

  if ( key[KEY_UP] ) {
    MenuPage::s_lastKey = KEY_UP;
    MenuPage::m_selection -= 1;
    if ( MenuPage::m_selection < 0 ) {
      MenuPage::m_selection = 6;
    }
    Sound::playSample(SMP_MENUITEM, false);

  } else if ( key[KEY_DOWN] ) {
    MenuPage::s_lastKey = KEY_DOWN;
    MenuPage::m_selection += 1;
    if ( MenuPage::m_selection > 6 ) {
      MenuPage::m_selection = 0;
    }
    Sound::playSample(SMP_MENUITEM, false);

  } else if ( key[KEY_ENTER] ) {
    MenuPage::s_lastKey = KEY_ENTER;
    ret = this->checkEnterKey();

  } else if ( key[KEY_SPACE] ) {
    MenuPage::s_lastKey = KEY_SPACE;
    ret = this->checkEnterKey();

  }
  
  // ESC - key cancels
  if ( key[KEY_ESC] ) {
    MenuPage::s_lastKey = KEY_ESC;
    MenuPage::m_selection = 0;
    ret = this->checkEnterKey();
    
  } else if ( key[KEY_BACKSPACE] ) {
    MenuPage::s_lastKey = KEY_BACKSPACE;
    MenuPage::m_selection = 0;
    ret = this->checkEnterKey();
    
  }
  return ret;
}


void MenuSaveGame::redraw()
{
  blit( GfxManager::titlePic, Display::buffer, 0,0, 0,0, 640,480 );
  
  TPrinter out( Display::buffer );
  out.font( GfxManager::titleFont, "dark30" );
  out.pos( 90,220 );
  out.print( "save current game" );
  
  char convbuff[8];
  string items[7];
  items[0] = "cancel";
  for (int i=1; i<7; i++) {
    int sn = m_slots.at(i-1).getSlotContent();
    if ( sn < 0 ) {
      items[i] = "empty slot";
    } else {
      items[i] = "level ";
      items[i] += string( itoa(sn+1, convbuff, 10) );
    }
  }
  
  int x = 170;
  int y = 260;
  for ( int i=0; i < 7; i++ ) {
    if ( MenuPage::m_selection == i ) {
      out.font( GfxManager::titleFont, "menuitems_sel" );
    } else {
      out.font( GfxManager::titleFont, "menuitems" );
    }
    out.pos( x,y );
    out.print( items[i] );
    y += 30;
  }
}


/** Returns the index of the selected save slot.
 * @returns Index of the saveslot or -1 if no slot was selected.
 */
int MenuSaveGame::getSlotIndex() const
{
  return MenuPage::m_selection - 1;
}


/** Checks the enterkey
 * @return    NO_PAGE_CHANGE or PAGE_CHANGE
 */
int MenuSaveGame::checkEnterKey()
{
  Sound::playSample( SMP_MENUSELECT, false );
  int ret = MenuPage::NO_PAGE_CHANGE;
  switch ( MenuPage::m_selection ) {
    case ( BACK_TO_LEVEL_MENU ): {
      ret = MenuPage::PAGE_CHANGE;
      break;
    }
    
    default: {
      ret = MenuPage::PAGE_CHANGE;
      break;
    }
  }
  return ret;
}

} // end of namespace
